//: ## ![3DaysOfSwift.com Logo](PageHeader.png) ✅ Swift Study Guide
//: ### Study These Language Features
//: ©️ copyright of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) | [3 Days of Swift Bootcamp](https://www.3DaysOfSwift.com/bootcamp) | [Interview Prep](https://www.3DaysOfSwift.com/interview-prep)
//:
//: -------------------
//:
//: ## ✅ ARC (Automatic Reference Counting)
//:
//: Classes spawn new instances.
//:
//: Those instances need to be managed in computer memory (RAM).
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


// → arc automatic reference counting
class CounterTest {
    init() {
        print("* initialise *")
    }
    deinit {
        print("* deinitialise *")
    }
}
let newInstance: CounterTest = CounterTest()


//:
//: -------------------
//:
//: ## Counting Up - Memory Management
//:
//: Each connection increments the counter by 1.
//:
//: -------------------
//:


var reference1: CounterTest? = CounterTest() // counter = 1
var reference2: CounterTest? = reference1    // counter = 2
var reference3: CounterTest? = reference1    // counter = 3
var reference4: CounterTest? = reference1    // counter = 4


//:
//: -------------------
//:
//: ## Counting Down - Memory Management
//:
//: Each disconnection decrements the couner by 1. When the counter reaches `0` the object is destroyed and removed from the computers RAM.
//:
//: -------------------
//:


reference1 = nil // counter = 3
reference2 = nil // counter = 2
reference3 = nil // counter = 1


//:
//: -------------------
//:
//: ## deinit
//:
//: When the counter reaches `0` the object is destroyed and removed from the computers RAM.
//:
//: -------------------
//:


// finally, let's destroy the object removing it from RAM
reference4 = nil // counter = 0 👻


//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ![3 Days Of Swift Logo](Footer.png) [Website](https://www.3DaysOfSwift.com) | [3 Days Of Swift Bootcamp](https://www.3DaysOfSwift.com/bootcamp) | [Interview Prep](https://www.3DaysOfSwift.com/interview-prep)
//:
//: © Copyright of [3DaysOfSwift.com](https://www.3DaysOfSwift.com). All rights reserved. Don't forget - come back when you've got an [interview](https://www.3DaysOfSwift.com/interview-prep)!
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
